import { NetworkFirst, type NetworkFirstOptions } from "workbox-strategies";

export class WebAppIndexStrategy extends NetworkFirst {
    constructor(options?: NetworkFirstOptions) {
        super({
            ...options,
            plugins: [
                ...(options?.plugins || []),
                {
                    cacheKeyWillBeUsed: async () => {
                        return new Request("/webapp/index.html");
                    }
                }
            ]
        });
    }
}
