import { ItemFlagFilter, SortDescriptor } from "@bluemind/core.container.api";

//FIXME : ITINERIS
//import { FlagUpdate, MailboxItemFlag } from "@bluemind/backend.mail.api";
//import ContainerDatasource from "@bluemind/service-worker-datasource";
//import { relaxedSynchronize } from "../../Synchronization/SyncUtils";

import { setupDatasourceError, setupMockDatasource } from "../../testUtils/MockDatasource";

import MailboxItemLocalDBProxy from "./MailboxItemLocalDBProxy";

const mockNext = vi.fn().mockResolvedValue(undefined);

vi.mock("@bluemind/service-worker-datasource", () => ({
    default: {
        retrieve: vi.fn()
    }
}));
vi.mock("@bluemind/logger", () => ({
    default: {
        error: vi.fn()
    }
}));
vi.mock("../../Synchronization/SyncUtils", () => ({
    relaxedSynchronize: vi.fn(),
    isLocal: vi.fn().mockResolvedValue(true),
    isSynchronized: vi.fn().mockResolvedValue(true)
}));

const setupProxy = () => new MailboxItemLocalDBProxy("api-key", "mailbox-uid");

describe("MailboxItemLocalDBProxy", () => {
    beforeEach(() => {
        vi.clearAllMocks();
    });
    describe("count()", () => {
        const filter: ItemFlagFilter = { must: ["Seen"], mustNot: [] };

        test("returns total matching items when datasource works", async () => {
            const { mockDb } = setupMockDatasource({
                getAllItemLight: vi.fn().mockResolvedValue([{ flags: ["Seen"] }, { flags: [] }])
            });
            const proxy = setupProxy();

            const result = await proxy.count(filter);

            expect(mockDb.getAllItemLight).toHaveBeenCalledOnce();
            expect(result).toEqual({ total: 1 });
        });

        test("fallbacks to next when datasource throws", async () => {
            setupDatasourceError();
            const proxy = setupProxy();
            proxy.next = mockNext;

            const result = await proxy.count(filter);

            expect(proxy.next).toHaveBeenCalledOnce();
            expect(result).toBeUndefined();
        });
    });

    describe("multipleGetById()", () => {
        const ids = [1, 2];

        test("retrieves defined items via proxy", async () => {
            const { mockDb } = setupMockDatasource({
                getItems: vi
                    .fn()
                    .mockResolvedValue([{ value: { flags: [] } }, undefined, { value: { flags: [] } }] as any)
            });
            const proxy = setupProxy();

            const result = await proxy.multipleGetById(ids);

            expect(mockDb.getItems).toHaveBeenCalledOnce();
            expect(result).toHaveLength(2);
        });

        test("fallbacks to next when datasource fails", async () => {
            setupDatasourceError();
            const proxy = setupProxy();
            proxy.next = mockNext;

            const result = await proxy.multipleGetById(ids);

            expect(proxy.next).toHaveBeenCalledOnce();
            expect(result).toBeUndefined();
        });
    });

    describe("sortedIds()", () => {
        const mailItems = [
            { internalId: 1, flags: ["Seen"], date: 100 },
            { internalId: 2, flags: [], date: 200 },
            { internalId: 3, flags: ["Seen"], date: 150 }
        ];

        test("sorts ascending by default field (date) and applies filter", async () => {
            setupMockDatasource({
                getAllItemLight: vi.fn().mockResolvedValue(mailItems)
            });
            const proxy = setupProxy();

            const sort: SortDescriptor = {
                fields: [{ column: "date", dir: "Asc" }],
                filter: { must: ["Seen"] }
            };

            const result = await proxy.sortedIds(sort);

            expect(result).toEqual([1, 3]);
        });

        test("returns descending order when dir=Desc", async () => {
            setupMockDatasource({
                getAllItemLight: vi.fn().mockResolvedValue(mailItems)
            });
            const proxy = setupProxy();

            const sort: SortDescriptor = {
                fields: [{ column: "date", dir: "Desc" }],
                filter: { must: ["Seen"] }
            };

            const result = await proxy.sortedIds(sort);

            expect(result).toEqual([3, 1]);
        });

        test("fallbacks to next on datasource error", async () => {
            setupDatasourceError();
            const proxy = setupProxy();
            proxy.next = mockNext;

            const result = await proxy.sortedIds();

            expect(proxy.next).toHaveBeenCalledOnce();
            expect(result).toBeUndefined();
        });
    });

    //FIXME : ITINERIS
    /* describe("addFlag()", () => {
        const flagUpdate: FlagUpdate = {
            itemsId: [10],
            mailboxItemFlag: "Flagged" as MailboxItemFlag
        };

        test("adds flag, persists items and returns version/timestamp", async () => {
            const version = 42;
            const { mockDb } = setupMockDatasource({
                getItems: vi.fn().mockResolvedValue([{ value: { flags: [] } }] as any),
                putItems: vi.fn().mockResolvedValue(undefined),
                getSyncStatus: vi.fn().mockResolvedValue({ version })
            });
            const mockRelaxedSynchronize = vi.mocked(relaxedSynchronize);
            mockRelaxedSynchronize.mockResolvedValue(undefined);
            const proxy = setupProxy();

            const result = await proxy.addFlag(flagUpdate);

            expect(mockDb.getItems).toHaveBeenCalledOnce();
            expect(mockDb.putItems).toHaveBeenCalledOnce();
            const storedItem = mockDb.putItems.mock.calls[0][0][0];
            expect(storedItem.value.flags).toContain("Flagged");
            expect(mockRelaxedSynchronize).toHaveBeenCalledOnce();
            expect(result?.version).toBe(version);
            expect(typeof result?.timestamp).toBe("number");
        });

        test("falls back to next when datasource throws", async () => {
            setupDatasourceError();
            const proxy = setupProxy();
            proxy.next = mockNext;

            const result = await proxy.addFlag(flagUpdate);

            expect(proxy.next).toHaveBeenCalledOnce();
            expect(result).toBeUndefined();
        });

        test("returns zero version when flagUpdate is missing", async () => {
            const proxy = setupProxy();

            const result = await proxy.addFlag(undefined);

            expect(result).toEqual({ version: 0, timestamp: expect.any(Number) });
        });
    });

    describe("deleteFlag()", () => {
        const flagUpdate: FlagUpdate = {
            itemsId: [20],
            mailboxItemFlag: "Seen" as MailboxItemFlag
        };

        test("removes flag, persists items and returns version/timestamp", async () => {
            const version = 7;
            const { mockDb } = setupMockDatasource({
                getItems: vi.fn().mockResolvedValue([{ value: { flags: ["Seen", "Flagged"] } }] as any),
                putItems: vi.fn().mockResolvedValue(undefined),
                getSyncStatus: vi.fn().mockResolvedValue({ version })
            });
            const mockRelaxedSynchronize = vi.mocked(relaxedSynchronize);
            mockRelaxedSynchronize.mockResolvedValue(undefined);
            const proxy = setupProxy();

            const result = await proxy.deleteFlag(flagUpdate);

            expect(mockDb.getItems).toHaveBeenCalledOnce();
            expect(mockDb.putItems).toHaveBeenCalledOnce();
            const storedItem = mockDb.putItems.mock.calls[0][0][0];
            expect(storedItem.value.flags).not.toContain("Seen");
            expect(mockRelaxedSynchronize).toHaveBeenCalledOnce();
            expect(result?.version).toBe(version);
            expect(typeof result?.timestamp).toBe("number");
        });

        test("fallbacks to next when datasource throws", async () => {
            setupDatasourceError();
            const proxy = setupProxy();
            proxy.next = mockNext;

            const result = await proxy.deleteFlag(flagUpdate);

            expect(proxy.next).toHaveBeenCalledOnce();
            expect(result).toBeUndefined();
        });

        test("returns zero version when flagUpdate is missing", async () => {
            const proxy = setupProxy();

            const result = await proxy.deleteFlag(undefined);

            expect(result).toEqual({ version: 0, timestamp: expect.any(Number) });
        });
    }); */
});
