import { describe, it, expect, vi, beforeEach, afterEach } from "vitest";

import serviceWorker from "@bluemind/commons.light/utils/service-worker";

import messageHandlerRegistry from "./ MessageHandlerRegistry";

const mockLogger = {
    log: vi.fn()
};

vi.mock("@bluemind/logger", () => {
    return {
        default: {
            log: vi.fn()
        }
    };
});
vi.mock("@bluemind/commons.light/utils/service-worker", () => {
    return {
        default: {
            addMessageListener: vi.fn()
        }
    };
});
// eslint-disable-next-line @typescript-eslint/no-explicit-any
declare const global: any;

describe("MessageHandler Registry", () => {
    beforeEach(() => {
        vi.resetAllMocks();
        global.logger = mockLogger;
    });

    afterEach(() => {
        vi.restoreAllMocks();
    });

    it("should register a handler for a specific message type", () => {
        const handler = {
            type: "TEST_TYPE",
            callback: vi.fn()
        };

        messageHandlerRegistry.register(handler);

        expect(serviceWorker.addMessageListener).toHaveBeenCalledWith(handler.type, expect.any(Function));
    });

    it("should call the callback when message type matches", async () => {
        const handler = {
            type: "TEST_TYPE",
            callback: vi.fn()
        };
        messageHandlerRegistry.register(handler);
        const addMessageListenerMock = serviceWorker.addMessageListener as any;
        const eventListener = addMessageListenerMock.mock.calls[0][1];
        const mockBody = { data: "test" };
        const mockHeaders = { sid: "123" };
        const mockEvent = {} as any;

        await eventListener(mockBody, mockHeaders, mockEvent);

        expect(handler.callback).toHaveBeenCalledWith(mockBody, mockHeaders, mockEvent);
    });
});
