/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.webappdata.api.IWebAppDataUids.
 */
namespace net.bluemind.webappdata.api
{

  public class WebAppDataUidsClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public WebAppDataUidsClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/webappdata/uids";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public String getContainerUid(String userUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{userUid}/_container_uid";
      methodPathValue = methodPathValue.Replace("{userUid}", HttpUtility.UrlEncode("" + userUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
