/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.user.api.IUserSubscription.
 */
namespace net.bluemind.user.api
{

  public class UserSubscriptionClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public UserSubscriptionClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/users/{domainUid}/subscriptions";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public List<net.bluemind.core.container.api.ContainerSubscriptionDescriptor> listSubscriptions(String subject, String type )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{subject}";
      methodPathValue = methodPathValue.Replace("{subject}", HttpUtility.UrlEncode("" + subject));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("type", type.ToString());

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.api.ContainerSubscriptionDescriptor>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void subscribe(String subject, List<net.bluemind.core.container.api.ContainerSubscription> subscriptions )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{subject}/_subscribe";
      methodPathValue = methodPathValue.Replace("{subject}", HttpUtility.UrlEncode("" + subject));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<net.bluemind.core.container.api.ContainerSubscription>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, subscriptions);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> subscribers(String containerUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_subscribers/{containerUid}";
      methodPathValue = methodPathValue.Replace("{containerUid}", HttpUtility.UrlEncode("" + containerUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void unsubscribe(String subject, List<String> containers )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{subject}/_unsubscribe";
      methodPathValue = methodPathValue.Replace("{subject}", HttpUtility.UrlEncode("" + subject));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, containers);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updateAutomount(String subject, List<net.bluemind.core.container.api.ContainerSubscription> subscriptions )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{subject}/_automount";
      methodPathValue = methodPathValue.Replace("{subject}", HttpUtility.UrlEncode("" + subject));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<net.bluemind.core.container.api.ContainerSubscription>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, subscriptions);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
