/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.user.api.ISharedMailbox.
 */
namespace net.bluemind.user.api
{

  public class SharedMailboxClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public SharedMailboxClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/shared_mailboxes/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public List<String> allUids()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_alluids";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> byEmail(String email )
    {
      String methodVerb = "GET";
      String methodPathValue = "/byEmail/{email}";
      methodPathValue = methodPathValue.Replace("{email}", HttpUtility.UrlEncode("" + email));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> byName(String login )
    {
      String methodVerb = "GET";
      String methodPathValue = "/byName/{login}";
      methodPathValue = methodPathValue.Replace("{login}", HttpUtility.UrlEncode("" + login));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> getLight(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/light";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.addressbook.api.VCard getVCard(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/vcard";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.addressbook.api.VCard>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
