/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.todolist.api.ITodoListsMgmt.
 */
namespace net.bluemind.todolist.api
{

  public class TodoListsMgmtClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public TodoListsMgmtClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/mgmt/todolists";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public void create(String containerUid, net.bluemind.core.container.model.ContainerDescriptor descriptor, Boolean isDefault )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{containerUid}";
      methodPathValue = methodPathValue.Replace("{containerUid}", HttpUtility.UrlEncode("" + containerUid));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("isDefault", isDefault.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ContainerDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, descriptor);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerDescriptor getComplete(String containerUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{containerUid}";
      methodPathValue = methodPathValue.Replace("{containerUid}", HttpUtility.UrlEncode("" + containerUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerDescriptor>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef reindex(String containerUid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{containerUid}/_reindex";
      methodPathValue = methodPathValue.Replace("{containerUid}", HttpUtility.UrlEncode("" + containerUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef reindexAll()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_reindex";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String containerUid, net.bluemind.core.container.model.ContainerDescriptor descriptor )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{containerUid}";
      methodPathValue = methodPathValue.Replace("{containerUid}", HttpUtility.UrlEncode("" + containerUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ContainerDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, descriptor);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
