/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.system.api
{
  [DataContract(Namespace="")]
  public partial class CloneConfiguration  {
    [DataMember]
    public String sourceInstallationId;
    
    [IgnoreDataMember]
    public Dictionary<String, String> uidToIpMapping = new Dictionary<String, String>();
    [DataMember(Name = "uidToIpMapping")]
    private uidToIpMappingSerializer uidToIpMappingSurrogate
    {
        get
        {
            return new uidToIpMappingSerializer(uidToIpMapping);
        }
        set
        {
            uidToIpMapping = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class uidToIpMappingSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public uidToIpMappingSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public uidToIpMappingSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
    [IgnoreDataMember]
    public Dictionary<String, String> sysconfOverride = new Dictionary<String, String>();
    [DataMember(Name = "sysconfOverride")]
    private sysconfOverrideSerializer sysconfOverrideSurrogate
    {
        get
        {
            return new sysconfOverrideSerializer(sysconfOverride);
        }
        set
        {
            sysconfOverride = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class sysconfOverrideSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public sysconfOverrideSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public sysconfOverrideSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
    [IgnoreDataMember]
    public net.bluemind.system.api.CloneConfigurationMode? mode;
    [DataMember(Name = "mode")]
    public String modeSurrogate
    {
        get
        {
            return mode.HasValue ? mode.ToString() : null;
        }
        set
        {
            net.bluemind.system.api.CloneConfigurationMode e;
            mode = Enum.TryParse(value, true, out e) ? e : (net.bluemind.system.api.CloneConfigurationMode?)null;
        }
    }
    
    [DataMember]
    public int? cloneWorkers;
    
    [DataMember]
    public List<String> skippedContainerTypes = new List<String>();
    
  
  }
}
