/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.scheduledjob.api
{
  [DataContract(Namespace="")]
  public partial class JobPlanification  {
    [IgnoreDataMember]
    public net.bluemind.scheduledjob.api.PlanKind? kind;
    [DataMember(Name = "kind")]
    public String kindSurrogate
    {
        get
        {
            return kind.HasValue ? kind.ToString() : null;
        }
        set
        {
            net.bluemind.scheduledjob.api.PlanKind e;
            kind = Enum.TryParse(value, true, out e) ? e : (net.bluemind.scheduledjob.api.PlanKind?)null;
        }
    }
    
    [DataMember]
    public net.bluemind.scheduledjob.api.JobRec rec = new net.bluemind.scheduledjob.api.JobRec();
    
    [IgnoreDataMember]
    public System.DateTime? lastRun;
    [DataMember(Name = "lastRun")]
    public String lastRunSurrogate
    {
      get
      {
        return (lastRun != null)
          ? "" + Math.Floor((((DateTime)lastRun) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          lastRun = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          lastRun = null;
        }
      }
    }
    
    [IgnoreDataMember]
    public System.DateTime? nextRun;
    [DataMember(Name = "nextRun")]
    public String nextRunSurrogate
    {
      get
      {
        return (nextRun != null)
          ? "" + Math.Floor((((DateTime)nextRun) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          nextRun = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          nextRun = null;
        }
      }
    }
    
    [DataMember]
    public String domain;
    
  
  }
}
