/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.mailbox.api.IMailboxes.
 */
namespace net.bluemind.mailbox.api
{

  public class MailboxesClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public MailboxesClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/mailboxes/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public long? addDomainRule(net.bluemind.mailbox.api.rules.MailFilterRule rule )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_rules";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.rules.MailFilterRule));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, rule);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<long?>(methodPathValue, queryParams, body, methodVerb);
    }
    public long? addMailboxRule(String mailboxUid, net.bluemind.mailbox.api.rules.MailFilterRule rule )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{mailboxUid}/_rules";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.rules.MailFilterRule));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, rule);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<long?>(methodPathValue, queryParams, body, methodVerb);
    }
    public long? addMailboxRuleRelative(String mailboxUid, net.bluemind.mailbox.api.rules.RuleMoveRelativePosition position, long? anchorId, net.bluemind.mailbox.api.rules.MailFilterRule rule )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{mailboxUid}/_rules/{position}/{anchorId}";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));
      methodPathValue = methodPathValue.Replace("{position}", HttpUtility.UrlEncode("" + position));
      methodPathValue = methodPathValue.Replace("{anchorId}", HttpUtility.UrlEncode("" + anchorId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.rules.MailFilterRule));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, rule);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<long?>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> byEmail(String email )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_byemail";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("email", email.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> byName(String name )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_byname";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("name", name.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> byRouting(net.bluemind.mailbox.api.MailboxRouting email )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_byRouting";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("email", email.ToString());

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void create(String uid, net.bluemind.mailbox.api.Mailbox mailbox )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.Mailbox));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, mailbox);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deleteDomainRule(long? id )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_rules/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deleteMailboxRule(String mailboxUid, long? id )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{mailboxUid}/_rules/{id}";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.MailFilter getDomainFilter()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_filter";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.MailFilter>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.rules.MailFilterRule getDomainRule(long? id )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_rules/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.rules.MailFilterRule>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.mailbox.api.rules.MailFilterRule> getDomainRules()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_rules";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.mailbox.api.rules.MailFilterRule>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.acl.AccessControlEntry> getMailboxAccessControlList(String mailboxUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{mailboxUid}/_acls";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.acl.AccessControlEntry>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.MailboxConfig getMailboxConfig(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_config";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.MailboxConfig>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.rules.DelegationRule getMailboxDelegationRule(String mailboxUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{mailboxUid}/_delegationRule";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.rules.DelegationRule>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.MailFilter getMailboxFilter(String mailboxUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{mailboxUid}/_filter";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.MailFilter>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.MailFilterForwarding getMailboxForwarding(String mailboxUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{mailboxUid}/_forwarding";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.MailFilterForwarding>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.MailboxQuota getMailboxQuota(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_quota";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.MailboxQuota>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.rules.MailFilterRule getMailboxRule(String mailboxUid, long? id )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{mailboxUid}/_rules/{id}";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.rules.MailFilterRule>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.mailbox.api.rules.MailFilterRule> getMailboxRules(String mailboxUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{mailboxUid}/_rules";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.mailbox.api.rules.MailFilterRule>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.mailbox.api.rules.MailFilterRule> getMailboxRulesByClient(String mailboxUid, String client )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{mailboxUid}/_rulesByClient";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("client", client.ToString());

      dynamic body = null;
      return this.execute<List<net.bluemind.mailbox.api.rules.MailFilterRule>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.mailbox.api.MailFilterVacation getMailboxVacation(String mailboxUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{mailboxUid}/_vacation";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.mailbox.api.MailFilterVacation>(methodPathValue, queryParams, body, methodVerb);
    }
    public int? getUnreadMessagesCount()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_unread";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<int?>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> list()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_list";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> listUids()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_listUids";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void moveMailboxRule(String mailboxUid, long? id, net.bluemind.mailbox.api.rules.RuleMoveDirection direction )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_rules/{id}/{direction}";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));
      methodPathValue = methodPathValue.Replace("{direction}", HttpUtility.UrlEncode("" + direction));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void moveMailboxRuleRelative(String mailboxUid, long? id, net.bluemind.mailbox.api.rules.RuleMoveRelativePosition position, long? anchorId )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_rules/{id}/{position}/{anchorId}";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));
      methodPathValue = methodPathValue.Replace("{position}", HttpUtility.UrlEncode("" + position));
      methodPathValue = methodPathValue.Replace("{anchorId}", HttpUtility.UrlEncode("" + anchorId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> multipleGet(List<String> uids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mget";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setDomainFilter(net.bluemind.mailbox.api.MailFilter filter )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_filter";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.MailFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, filter);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setMailboxAccessControlList(String mailboxUid, List<net.bluemind.core.container.model.acl.AccessControlEntry> accessControlEntries )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_acls";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<net.bluemind.core.container.model.acl.AccessControlEntry>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, accessControlEntries);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setMailboxDelegationRule(String mailboxUid, net.bluemind.mailbox.api.rules.DelegationRule delegationRule )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_delegationRule";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.rules.DelegationRule));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, delegationRule);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setMailboxFilter(String mailboxUid, net.bluemind.mailbox.api.MailFilter filter )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_filter";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.MailFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, filter);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setMailboxForwarding(String mailboxUid, net.bluemind.mailbox.api.MailFilterForwarding forwarding )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_forwarding";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.MailFilterForwarding));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, forwarding);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setMailboxVacation(String mailboxUid, net.bluemind.mailbox.api.MailFilterVacation vacation )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_vacation";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.MailFilterVacation));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, vacation);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.mailbox.api.Mailbox mailbox )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.Mailbox));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, mailbox);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updateDomainRule(long? id, net.bluemind.mailbox.api.rules.MailFilterRule rule )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_rules/{id}";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.rules.MailFilterRule));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, rule);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void updateMailboxRule(String mailboxUid, long? id, net.bluemind.mailbox.api.rules.MailFilterRule rule )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_rules/{id}";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.mailbox.api.rules.MailFilterRule));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, rule);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
