/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.mailbox.api.IMailboxMgmt.
 */
namespace net.bluemind.mailbox.api
{

  public class MailboxMgmtClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public MailboxMgmtClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/mgmt/mailbox/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public net.bluemind.core.task.api.TaskRef addIndexToRing(int? numericIndex )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{numericIndex}/_add_index";
      methodPathValue = methodPathValue.Replace("{numericIndex}", HttpUtility.UrlEncode("" + numericIndex));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef consolidateDomain()
    {
      String methodVerb = "POST";
      String methodPathValue = "/_consolidate";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef consolidateMailbox(String mailboxUid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_consolidate";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef deleteIndexFromRing(int? numericIndex )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{numericIndex}/_remove_index";
      methodPathValue = methodPathValue.Replace("{numericIndex}", HttpUtility.UrlEncode("" + numericIndex));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.mailbox.api.SimpleShardStats> getLiteStats()
    {
      String methodVerb = "GET";
      String methodPathValue = "/liteStats";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.mailbox.api.SimpleShardStats>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.mailbox.api.ShardStats> getShardsStats()
    {
      String methodVerb = "GET";
      String methodPathValue = "/shardsStats";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.mailbox.api.ShardStats>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef moveIndex(String mailboxUid, String index, Boolean deleteSource )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_move_index";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("index", index.ToString());
      queryParams.Add("deleteSource", deleteSource.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef resetMailbox(String mailboxUid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_reset";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef respawnMailbox(String mailboxUid )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{mailboxUid}/_respawn";
      methodPathValue = methodPathValue.Replace("{mailboxUid}", HttpUtility.UrlEncode("" + mailboxUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
