/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.directory.api.IDirectory.
 */
namespace net.bluemind.directory.api
{

  public class DirectoryClient : BMClient
  {
    private String domain;
  
    /*
     * Constructor 
     */
    public DirectoryClient(String baseUrl, String sid , String domain )
    {
      this.baseUrl = baseUrl + "/api/directory/{domain}";      
      this.sid = sid;
      this.domain = domain;
      this.baseUrl = this.baseUrl.Replace("{domain}", domain);
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public net.bluemind.core.container.model.ContainerChangeset<String> changeset(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changeset";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef delete(String path )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{path}";
      methodPathValue = methodPathValue.Replace("{path}", HttpUtility.UrlEncode("" + path));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef deleteByEntryUid(String entryUid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_byentryuid/{entryUid}";
      methodPathValue = methodPathValue.Replace("{entryUid}", HttpUtility.UrlEncode("" + entryUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.directory.api.DirEntry findByEntryUid(String entryUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/entry-uid/{entryUid}";
      methodPathValue = methodPathValue.Replace("{entryUid}", HttpUtility.UrlEncode("" + entryUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.directory.api.DirEntry>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry> findItemValueByEntryUid(String entryUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/item-value-uid/{entryUid}";
      methodPathValue = methodPathValue.Replace("{entryUid}", HttpUtility.UrlEncode("" + entryUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.directory.api.DirEntry getByEmail(String email )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_byEmail/{email}";
      methodPathValue = methodPathValue.Replace("{email}", HttpUtility.UrlEncode("" + email));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.directory.api.DirEntry>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>> getByRoles(List<String> roles )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_byroles";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, roles);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.directory.api.DirEntry> getEntries(String path )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_childs";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, path);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.directory.api.DirEntry>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.directory.api.DirEntry getEntry(String path )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_entry";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, path);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.directory.api.DirEntry>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getEntryIcon(String entryUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/entry-uid/{entryUid}/icon";
      methodPathValue = methodPathValue.Replace("{entryUid}", HttpUtility.UrlEncode("" + entryUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getEntryPhoto(String entryUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/entry-uid/{entryUid}/photo";
      methodPathValue = methodPathValue.Replace("{entryUid}", HttpUtility.UrlEncode("" + entryUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getIcon(String path )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_icon/{path}";
      methodPathValue = methodPathValue.Replace("{path}", HttpUtility.UrlEncode("" + path));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>> getMultiple(List<String> id )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mget";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, id);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>> getMultipleLight(List<String> id )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mgetlight";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, id);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> getRolesForDirEntry(String entryUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/entry-uid/{entryUid}/rolesfor_";
      methodPathValue = methodPathValue.Replace("{entryUid}", HttpUtility.UrlEncode("" + entryUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> getRolesForOrgUnit(String ouUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/ou-uid/{ouUid}/rolesfor_";
      methodPathValue = methodPathValue.Replace("{ouUid}", HttpUtility.UrlEncode("" + ouUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.directory.api.DirEntry getRoot()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.directory.api.DirEntry>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard> getVCard(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_vcard";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.addressbook.api.VCard>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>> search(net.bluemind.directory.api.DirEntryQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_search";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.directory.api.DirEntryQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.DirEntry>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<String> searchUids(net.bluemind.directory.api.DirEntryQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_searchUids";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.directory.api.DirEntryQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.api.ListResult<String>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
