/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.directory.api
{
  [DataContract(Namespace="")]
  public partial class DirEntryQuery  {
    [DataMember]
    public net.bluemind.directory.api.DirEntryQueryOrder order = new net.bluemind.directory.api.DirEntryQueryOrder();
    
    [DataMember]
    public String nameFilter;
    
    [DataMember]
    public Boolean hiddenFilter;
    
    [DataMember]
    public String emailFilter;
    
    [DataMember]
    public String nameOrEmailFilter;
    
    [IgnoreDataMember]
    public net.bluemind.directory.api.DirEntryQueryStateFilter? stateFilter;
    [DataMember(Name = "stateFilter")]
    public String stateFilterSurrogate
    {
        get
        {
            return stateFilter.HasValue ? stateFilter.ToString() : null;
        }
        set
        {
            net.bluemind.directory.api.DirEntryQueryStateFilter e;
            stateFilter = Enum.TryParse(value, true, out e) ? e : (net.bluemind.directory.api.DirEntryQueryStateFilter?)null;
        }
    }
    
    [DataMember]
    public Boolean systemFilter;
    
    [IgnoreDataMember]
    public List<net.bluemind.directory.api.BaseDirEntryKind> kindsFilter = new List<net.bluemind.directory.api.BaseDirEntryKind>();
    [DataMember(Name = "kindsFilter")]
    public List<String> kindsFilterSurrogate
    {
        get
        {
            return kindsFilter == null ? null : kindsFilter.Select(v => v.ToString()).ToList();
        }
        set
        {
            kindsFilter = new List<net.bluemind.directory.api.BaseDirEntryKind>();
            foreach (string s in value)
            {
                net.bluemind.directory.api.BaseDirEntryKind e;
                if (Enum.TryParse(s, true, out e))
                {
                    kindsFilter.Add(e);
                }
            }            
        }
    }
    
    [DataMember]
    public List<String> entries = new List<String>();
    
    [DataMember]
    public List<long?> orgUnitIds = new List<long?>();
    
    [IgnoreDataMember]
    public net.bluemind.directory.api.BaseDirEntryAccountType? accountTypeFilter;
    [DataMember(Name = "accountTypeFilter")]
    public String accountTypeFilterSurrogate
    {
        get
        {
            return accountTypeFilter.HasValue ? accountTypeFilter.ToString() : null;
        }
        set
        {
            net.bluemind.directory.api.BaseDirEntryAccountType e;
            accountTypeFilter = Enum.TryParse(value, true, out e) ? e : (net.bluemind.directory.api.BaseDirEntryAccountType?)null;
        }
    }
    
    [DataMember]
    public int? from;
    
    [DataMember]
    public int? size;
    
    [DataMember]
    public List<String> entryUidFilter = new List<String>();
    
    [DataMember]
    public Boolean onlyManagable;
    
    [DataMember]
    public String dataLocation;
    
    [DataMember]
    public Boolean lightResults;
    
  
  }
}
