/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.core.container.api.IOfflineMgmt.
 */
namespace net.bluemind.core.container.api
{

  public class OfflineMgmtClient : BMClient
  {
    private String domainUid;
    private String ownerUid;
  
    /*
     * Constructor 
     */
    public OfflineMgmtClient(String baseUrl, String sid , String domainUid , String ownerUid )
    {
      this.baseUrl = baseUrl + "/api/offline/{domainUid}/{ownerUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.ownerUid = ownerUid;
      this.baseUrl = this.baseUrl.Replace("{ownerUid}", ownerUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public net.bluemind.core.container.api.IdRange allocateOfflineIds(int? idCount )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_allocateOfflineIds";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("idCount", idCount.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.api.IdRange>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
