/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.core.container.api.IItemChangelogSupport.
 */
namespace net.bluemind.core.container.api
{

  public class ItemChangelogSupportClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public ItemChangelogSupportClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public net.bluemind.core.container.model.ItemChangelog itemChangelog(String uid, long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_itemchangelog";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(long?));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, since);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ItemChangelog>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
