/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.core.container.api.IInternalContainersByLocation.
 */
namespace net.bluemind.core.container.api
{

  public class InternalContainersByLocationClient : BMClient
  {
    private String location;
  
    /*
     * Constructor 
     */
    public InternalContainersByLocationClient(String baseUrl, String sid , String location )
    {
      this.baseUrl = baseUrl + "/api/containers/{location}/_by_location";      
      this.sid = sid;
      this.location = location;
      this.baseUrl = this.baseUrl.Replace("{location}", location);
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public List<net.bluemind.core.container.model.BaseContainerDescriptor> listByType(net.bluemind.core.container.api.ContainerQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/list_by_type";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.api.ContainerQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.BaseContainerDescriptor>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
