/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.core.container.api.IContainerSync.
 */
namespace net.bluemind.core.container.api
{

  public class ContainerSyncClient : BMClient
  {
    private String containerUid;
  
    /*
     * Constructor 
     */
    public ContainerSyncClient(String baseUrl, String sid , String containerUid )
    {
      this.baseUrl = baseUrl + "/api/containers/_sync/{containerUid}";      
      this.sid = sid;
      this.containerUid = containerUid;
      this.baseUrl = this.baseUrl.Replace("{containerUid}", containerUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public System.DateTime? getLastSync()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_last";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<System.DateTime?>(methodPathValue, queryParams, body, methodVerb);
    }
    public System.DateTime? getNextSync()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_next";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<System.DateTime?>(methodPathValue, queryParams, body, methodVerb);
    }
    public String getSyncStatus()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_status";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef sync()
    {
      String methodVerb = "PUT";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
