/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.calendar.api.IPublicFreebusy.
 */
namespace net.bluemind.calendar.api
{

  public class PublicFreebusyClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public PublicFreebusyClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/calendars/sfreebusy";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public net.bluemind.calendar.api.VFreebusy get(String email, String callerUserUid, String callerDomain, net.bluemind.calendar.api.VFreebusyQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{email}";
      methodPathValue = methodPathValue.Replace("{email}", HttpUtility.UrlEncode("" + email));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("callerUserUid", callerUserUid.ToString());
      queryParams.Add("callerDomain", callerDomain.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.calendar.api.VFreebusyQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.calendar.api.VFreebusy>(methodPathValue, queryParams, body, methodVerb);
    }
    public String getAsString(String email, String callerUserUid, String callerDomain, net.bluemind.calendar.api.VFreebusyQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{email}/_ics";
      methodPathValue = methodPathValue.Replace("{email}", HttpUtility.UrlEncode("" + email));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("callerUserUid", callerUserUid.ToString());
      queryParams.Add("callerDomain", callerDomain.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.calendar.api.VFreebusyQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public String simple(String email, String callerUserUid, String callerDomain )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{email}";
      methodPathValue = methodPathValue.Replace("{email}", HttpUtility.UrlEncode("" + email));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("callerUserUid", callerUserUid.ToString());
      queryParams.Add("callerDomain", callerDomain.ToString());

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
