/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.backend.mail.api
{
  [DataContract(Namespace="")]
  public partial class MessageSearchResult  {
    [DataMember]
    public String containerUid;
    
    [DataMember]
    public long? itemId;
    
    [DataMember]
    public String subject;
    
    [DataMember]
    public int? size;
    
    [DataMember]
    public String messageClass;
    
    [IgnoreDataMember]
    public System.DateTime? date;
    [DataMember(Name = "date")]
    public String dateSurrogate
    {
      get
      {
        return (date != null)
          ? "" + Math.Floor((((DateTime)date) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          date = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          date = null;
        }
      }
    }
    
    [DataMember]
    public net.bluemind.backend.mail.api.MessageSearchResultMbox from = new net.bluemind.backend.mail.api.MessageSearchResultMbox();
    
    [DataMember]
    public net.bluemind.backend.mail.api.MessageSearchResultMbox to = new net.bluemind.backend.mail.api.MessageSearchResultMbox();
    
    [DataMember]
    public Boolean seen;
    
    [DataMember]
    public Boolean flagged;
    
    [DataMember]
    public Boolean hasAttachment;
    
    [DataMember]
    public String preview;
    
    [DataMember]
    public double? score;
    
    [DataMember]
    public String owner;
    
  
  }
}
