/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.backend.mail.api.IMailFinder.
 */
namespace net.bluemind.backend.mail.api
{

  public class MailFinderClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public MailFinderClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/mail_finder/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3112";
    }
    
    public net.bluemind.backend.mail.api.SearchResult search(net.bluemind.backend.mail.api.MailFinderQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_search/";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.backend.mail.api.MailFinderQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.backend.mail.api.SearchResult>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
