#
#  BEGIN LICENSE
#  Copyright (c) Blue Mind SAS, 2012-2016
# 
#  This file is part of BlueMind. BlueMind is a messaging and collaborative
#  solution.
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of either the GNU Affero General Public License as
#  published by the Free Software Foundation (version 3 of the License).
# 
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# 
#  See LICENSE.txt
#  END LICENSE
#
import requests
import json
from netbluemind.python import serder
from netbluemind.python.client import BaseEndpoint

ISecurityToken_VERSION = "5.5.3112"

class ISecurityToken(BaseEndpoint):
    def __init__(self, apiKey, url ,sessionIdentifier ):
        self.url = url
        self.apiKey = apiKey
        self.base = url +'/auth/token/{sessionIdentifier}'
        self.sessionIdentifier_ = sessionIdentifier
        self.base = self.base.replace('{sessionIdentifier}',sessionIdentifier)

    def destroy (self):
        postUri = "/_delete";
        __data__ = None
        __encoded__ = None
        queryParams = {  };

        response = requests.delete( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ISecurityToken_VERSION}, data = __encoded__);
        return self.handleResult__(None, response)
    def renew (self):
        postUri = "/_renew";
        __data__ = None
        __encoded__ = None
        queryParams = {  };

        response = requests.post( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ISecurityToken_VERSION}, data = __encoded__);
        return self.handleResult__(None, response)
    def upgrade (self):
        postUri = "/_upgrade";
        __data__ = None
        __encoded__ = None
        queryParams = {  };

        response = requests.put( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ISecurityToken_VERSION}, data = __encoded__);
        return self.handleResult__(None, response)
