<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2017
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
namespace BM;
require_once 'GlobalEnv.php';

/**
 * Implementation of net.bluemind.resource.api.IResources.
 */

class ResourcesClient {

  protected $base;
  protected $sid;
  protected $domainUid;

  /*
   * Constructor.
   *
   * @param base
   * @param sid
   * @param domainUid
   *
   */
  public function __construct($base, $sid , $domainUid) {
    $this->sid = $sid;
    $this->base = $base."/api/resources/{domainUid}";
    $this->domainUid = $domainUid;
    $this->base = str_replace("{domainUid}", urlencode($domainUid), $this->base);
  }


  /*
   * @param uid
   * @param eventInfo
   * @return
   */
  public function addToEventDescription( $uid ,  $eventInfo  ) {
    $postUri = "/{uid}/addToEventDesc";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $eventInfo;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param email
   * @return
   */
  public function byEmail( $email  ) {
    $postUri = "/byEmail/{email}";
    $method = "GET";

    $postUri = str_replace("{email}", urlencode($email), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param type
   * @return
   */
  public function byType( $type  ) {
    $postUri = "/byType/{type}";
    $method = "GET";

    $postUri = str_replace("{type}", urlencode($type), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param resourceDescriptor
   * @return
   */
  public function create( $uid ,  $resourceDescriptor  ) {
    $postUri = "/{uid}";
    $method = "PUT";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $resourceDescriptor;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function delete_( $uid  ) {
    $postUri = "/{uid}";
    $method = "DELETE";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function get( $uid  ) {
    $postUri = "/{uid}";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getIcon( $uid  ) {
    $postUri = "/{uid}/icon";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param eventInfo
   * @return
   */
  public function removeFromEventDescription( $uid ,  $eventInfo  ) {
    $postUri = "/{uid}/removeFromEventDesc";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $eventInfo;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param icon
   * @return
   */
  public function setIcon( $uid ,  $icon  ) {
    $postUri = "/{uid}/icon";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $icon;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param resourceDescriptor
   * @return
   */
  public function update( $uid ,  $resourceDescriptor  ) {
    $postUri = "/{uid}";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $resourceDescriptor;
    return $this->execute($url, $queryParam, $body, $method);
  }


  /*
   * Execute the request
   *
   * @param url
   * @param data
   * @param body
   */
  private function execute($url, $queryParam, $body, $method) {

    $curl = curl_init();

    $headers = array();
    array_push($headers, 'X-BM-ApiKey: '.$this->sid);

    if (sizeof($queryParam) > 0) {
      $url .= '?'.http_build_query($queryParam);
    }

    curl_setopt_array($curl, GlobalEnv::$curlOptions + array(
      CURLOPT_URL => $url,
      CURLOPT_HTTPHEADER => $headers,
      CURLOPT_CUSTOMREQUEST => $method)
    );

    if ($method == 'POST') {
      curl_setopt($curl, CURLOPT_POST, TRUE);
      curl_setopt($curl, CURLOPT_POSTFIELDS, array());
    }

    if (is_resource($body)) {
      if ($method == 'PUT') {
        curl_setopt($curl, CURLOPT_PUT, TRUE);
      }
      $size = fstat($body)['size'];
      curl_setopt($curl, CURLOPT_INFILE, $body);
      curl_setopt($curl, CURLOPT_INFILESIZE, $size);
    } else {
      if (is_object($body) && method_exists($body, 'serialize')) {
        $body = $body->serialize();
      } else if (is_object($body)) {
        $body = json_encode($body);
      } else if (is_array($body)) {
        $body = json_encode($body);
      } else if (is_string($body)) {
        $body = json_encode($body);
      }
      $size = strlen($body);
      array_push($headers, 'Content-Type: application/json');
      array_push($headers, 'Content-Length: '.$size);
      curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($curl, CURLOPT_POSTFIELDS, $body);
    }

    $resp = curl_exec($curl);
    if ($resp === false) {
      throw new \Exception(curl_error($curl));
    } 
    curl_close($curl);
    if (!$resp) {
      return;
    }
    $js = json_decode($resp);
    if ($js === NULL) {
      return $resp;
    }
    if (isset($js->errorCode)) {
      throw new \Exception($js->errorCode . ': ' . (isset($js->message) ? ' : ' . $js->message : ''));
    }
    return $js;
  }

}
