/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.ui.common.client.forms.acl;


import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;

import net.bluemind.core.container.model.acl.Verb;

public class AclCombination {
	private AclComboList aclList;
	private AclComboDelegationList aclDelegationList;
	private Label delegationMessage;

	public FlowPanel delegationPanel;

	public AclCombination(AclComboList aclList, AclComboDelegationList aclDelegationList, Label delegationMessage, boolean isMailboxCtx) {
		this.aclList = aclList;
		this.aclDelegationList = aclDelegationList;
		this.delegationMessage = delegationMessage;
		this.delegationPanel = new FlowPanel();
		
		this.aclList.getComboList().addChangeHandler(new ChangeHandler() {
			@Override
			public void onChange(ChangeEvent event) {
				if (isMailboxCtx) {
					updateDelegationPanelContent(aclList.getValue() != Verb.All);
				}
			}
		});
	}

	public void updateDelegationPanelContent(boolean canChooseDelegation) {
		this.aclDelegationList.getComboList().setVisible(canChooseDelegation);
		this.delegationMessage.setVisible(!canChooseDelegation);
		this.delegationPanel.add(canChooseDelegation ? this.aclDelegationList : this.delegationMessage);
	}

	public AclComboList getAclComboList() {
		return aclList;
	}

	public AclComboDelegationList getAclComboDelegationList() {
		return aclDelegationList;
	}
}
