/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.tx.outbox.repository;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

import net.bluemind.lifecycle.helper.SoftReset;

public class FlushSeqHolder {
	public final AtomicLong addedForBackup;
	public final AtomicLong flushed;
	private static Map<Integer, FlushSeqHolder> flushers = new ConcurrentHashMap<>();

	private FlushSeqHolder() {
		addedForBackup = new AtomicLong();
		flushed = initFlushed();
	}

	private AtomicLong initFlushed() {
		AtomicLong fl = new AtomicLong();
		SoftReset.register(() -> {
			addedForBackup.set(0);
			fl.set(0);
		});
		return fl;
	}

	public static FlushSeqHolder get(Object obj) {
		return flushers.computeIfAbsent(obj.hashCode(), hc -> new FlushSeqHolder());
	}
}
