package net.bluemind.directory.hollow.datamodel.consumer.multicore.index;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

import net.bluemind.directory.hollow.datamodel.consumer.multicore.index.impl.ByDistinguishedName;
import net.bluemind.directory.hollow.datamodel.consumer.multicore.index.impl.ByEmail;
import net.bluemind.directory.hollow.datamodel.consumer.multicore.index.impl.ByKind;
import net.bluemind.directory.hollow.datamodel.consumer.multicore.index.impl.ByMinimalId;
import net.bluemind.directory.hollow.datamodel.consumer.multicore.index.impl.ByNameOrEmailPrefix;
import net.bluemind.directory.hollow.datamodel.consumer.multicore.index.impl.ByUid;

public class IndexCatalog {

	private ByUid byUid = new ByUid();
	private ByKind byKind = new ByKind();
	private ByEmail byEmail = new ByEmail();
	private ByDistinguishedName byDistinguishedName = new ByDistinguishedName();
	private ByNameOrEmailPrefix byNameOrEmailPrefix = new ByNameOrEmailPrefix();
	private ByMinimalId byMinimalId = new ByMinimalId();

	private Collection<IDeserializerIndex> catalog;

	private Map<String, IDeserializerIndex> simpleQueryCatalog;

	public IndexCatalog() {
		catalog = new HashSet<>();
		catalog.add(byUid);
		catalog.add(byKind);
		catalog.add(byEmail);
		catalog.add(byDistinguishedName);
		catalog.add(byNameOrEmailPrefix);
		catalog.add(byMinimalId);

		simpleQueryCatalog = catalog.stream()//
				.filter(index -> index.simpleQueryFieldName().isPresent())
				.collect(Collectors.toMap(index -> index.simpleQueryFieldName().get(), Function.identity()));
	}

	public Optional<IDeserializerIndex> getForSimpleQuery(String fieldName) {
		return Optional.ofNullable(simpleQueryCatalog.get(fieldName));
	}

	public Collection<IDeserializerIndex> getAll() {
		return catalog;
	}

	public ByUid getByUid() {
		return byUid;
	}

	public ByKind getByKind() {
		return byKind;
	}

	public ByEmail getByEmail() {
		return byEmail;
	}

	public ByDistinguishedName getByDistinguishedName() {
		return byDistinguishedName;
	}

	public ByNameOrEmailPrefix getByNameOrEmailPrefix() {
		return byNameOrEmailPrefix;
	}

	public ByMinimalId getByMinimalId() {
		return byMinimalId;
	}

}
