package net.bluemind.core.backup.continuous.events.bodies;

import com.google.common.util.concurrent.RateLimiter;

import net.bluemind.backend.mail.replica.api.MailboxRecord;
import net.bluemind.backend.mail.replica.hook.IMessageBodyHook;
import net.bluemind.core.backup.continuous.dto.IndexedMessageBodyDTO;
import net.bluemind.core.backup.continuous.events.ContinuousContenairization;

public class MessageBodyESSourceHook
		implements IMessageBodyHook, ContinuousContenairization<IndexedMessageBodyDTO>, IBaseBodyHooks {

	@Override
	public String type() {
		return "message_bodies_es_source";
	}

	private final RateLimiter warnLimit = RateLimiter.create(1.0 / 2);

	@Override
	public void preCreate(String domainUid, String ownerId, MailboxRecord mailboxRecord) {
		// not now
	}

	@Override
	public void preUpdate(String domainUid, String ownerId, MailboxRecord mailboxRecord) {
		// not now
	}

	@Override
	public void preIndex(String guid, byte[] esSource) {
		if (targetOutbox("global.virt", "admin0").isPaused()) {
			return;
		}

		String domainUid = domainUid();
		String ownerId = ownerId(guid);
		try {
			if (warnLimit.tryAcquire()) {
				logger.warn("Slow ES push to kafka triggered on {}", guid);
			}

			IndexedMessageBodyDTO dto = new IndexedMessageBodyDTO(esSource);
			save(domainUid, ownerId, guid, dto, true);
		} catch (Exception e) {
			logger.warn("Cannot push {}", type(), e);
		}
	}

	@Override
	public void preDelete(String guid) {
		IndexedMessageBodyDTO dto = new IndexedMessageBodyDTO();
		dto.data = new byte[0];
		delete(domainUid(), ownerId(guid), guid, dto);
	}

}
