/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.backup.continuous.events;

import net.bluemind.core.container.model.BaseContainerDescriptor;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.tx.outbox.api.ITxOutbox;

public class TxOutboxLookup {

	private TxOutboxLookup() {
	}

	public static ITxOutbox forOwnerAndType(String type, String domainUid, String owner) {
		return getTxOutbox(domainUid, owner, type, "");
	}

	public static ITxOutbox forContainer(BaseContainerDescriptor desc) {
		return getTxOutbox(desc.domainUid, desc.owner, desc.type, desc.uid);
	}

	private static ITxOutbox getTxOutbox(String domainUid, String owner, String type, String containerUid) {
		return ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).instance(ITxOutbox.class, domainUid, owner,
				type, containerUid, DataLocation.directory().serverUid());
	}

}
