package net.bluemind.directory.hollow.datamodel.producer;

import net.bluemind.core.container.model.ItemValue;
import net.bluemind.directory.api.BaseDirEntry.Kind;
import net.bluemind.directory.api.DirEntry;

public interface IDirectorySerializer {

	void init();

	long produce();

	void start();

	public void remove();

	void rebuild();

	default boolean supportedType(ItemValue<DirEntry> iv) {
		return !iv.value.system
				&& (iv.value.kind == Kind.USER || iv.value.kind == Kind.GROUP || iv.value.kind == Kind.MAILSHARE
						|| iv.value.kind == Kind.RESOURCE || iv.value.kind == Kind.EXTERNALUSER
						|| iv.value.kind == Kind.ADDRESSBOOK || iv.value.kind == Kind.CALENDAR
						|| iv.value.kind == Kind.SHARED_MAILBOX);
	}

	public long getLastVersion();
}
