/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.cql.store.factories;

import net.bluemind.backend.mail.cql.store.CqlBodyTierChangeStore;
import net.bluemind.backend.mail.repository.IBodyTierChangeStore;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.CqlSessions;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.repository.provider.IStandaloneFactory;

public class TierChangeFactory extends CqlRepositoryFactory<IBodyTierChangeStore>
		implements IStandaloneFactory<IBodyTierChangeStore> {

	@Override
	public Class<IBodyTierChangeStore> factoryClass() {
		return IBodyTierChangeStore.class;
	}

	@Override
	public IBodyTierChangeStore instance(BmContext context) throws ServerFault {
		return new CqlBodyTierChangeStore(CqlSessions.forKeyspace("core"));
	}

}
