/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.cql.store;

import java.sql.SQLException;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.backend.mail.replica.api.SubtreeLocation;
import net.bluemind.backend.mail.repository.IReplicasStore;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.container.repository.IContainerStore;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.persistence.CqlAbstractStore;
import net.bluemind.repository.provider.RepositoryProvider;

public class CqlReplicasStore extends CqlAbstractStore implements IReplicasStore {

	private final BmContext ctx;

	public CqlReplicasStore(CqlSession s, BmContext ctx) {
		super(s);
		this.ctx = ctx;
	}

	private record ContAndItem(long cont, long item) {

	}

	private static final int SUBTREE_LEN = "subtree_".length();

	@Override
	public SubtreeLocation byUniqueId(String uniqueId) throws SQLException {
		ContAndItem found = unique("SELECT container_id, id from idx_item_by_uid where uid=?",
				r -> new ContAndItem(r.getLong(0), r.getLong(1)), voidPop(), uniqueId);

		if (found == null) {
			return null;
		}
		String name = unique("SELECT name FROM t_mailbox_replica WHERE container_id=? AND item_id=?",
				r -> r.getString(0), voidPop(), found.cont(), found.item());

		IContainerStore contStore = RepositoryProvider.instance(IContainerStore.class, ctx, DataLocation.directory());
		Container cont = contStore.get(found.cont);

		SubtreeLocation sl = new SubtreeLocation();
		sl.folderItemId = found.item();
		sl.contName = cont.name;
		sl.boxName = name;
		sl.subtreeContainer = cont.uid;
		sl.partition = sl.subtreeContainer.substring(SUBTREE_LEN, sl.subtreeContainer.indexOf('!', SUBTREE_LEN));

		return sl;
	}

}
