<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * FileHostingItem.
 */
class FileHostingItem  {

  /*
   * @type String
   */
  public $path;

  /*
   * @type String
   */
  public $name;

  /*
   * @type FileType
   */
  public $type;

  /*
   * @type Long
   */
  public $size;

  /*
   * @type List
   */
  public $metadata;

  /*
   * Constructor
   */
  public function __construct() {
    $this->path = "";
    $this->name = "";
    $this->size = null;
    $this->metadata =  array();
  }

  public function toMap() {
    $data = array(    
        "path" => empty($this->path) ? null : $this->path,    
        "name" => empty($this->name) ? null : $this->name,    
        "type" => empty($this->type) ? null : $this->type,    
        "size" => empty($this->size) ? null : $this->size,    
        "metadata" => empty($this->metadata) ? null : $this->metadata);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
