/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.index.mail;

import java.util.List;

import net.bluemind.backend.mail.replica.hook.IMessageBodyHook;
import net.bluemind.eclipse.common.RunnableExtensionLoader;

public class BodyHooks {

	private static final List<IMessageBodyHook> hooks = List.copyOf(getHooks());

	private BodyHooks() {
	}

	private static List<IMessageBodyHook> getHooks() {
		RunnableExtensionLoader<IMessageBodyHook> loader = new RunnableExtensionLoader<>();
		return loader.loadExtensions("net.bluemind.backend.mail.replica.hook", "messagebodyhook", "hook", "impl");
	}

	public static List<IMessageBodyHook> get() {
		return hooks;
	}

}
