/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.central.reverse.proxy;

import java.util.concurrent.CompletableFuture;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.base.Stopwatch;

import net.bluemind.lib.vertx.VertxPlatform;

public class ReverseProxyServer {

	private static final Logger logger = LoggerFactory.getLogger(ReverseProxyServer.class);

	public CompletableFuture<Void> run() {
		CompletableFuture<Void> comp = new CompletableFuture<>();
		var chrono = Stopwatch.createStarted();
		VertxPlatform.spawnVerticles(ar -> {
			if (ar.failed()) {
				comp.completeExceptionally(ar.cause());
			} else {
				logger.info("CRP verticles deployement done after {}s", chrono.elapsed().toSeconds());
				comp.complete(ar.result());
			}
		});
		return comp;

	}

}
