/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.persistence;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.rest.BmContext;
import net.bluemind.repository.sequences.IItemSequencesStore;

public class ItemSequencesStore implements IItemSequencesStore {

	private static final Logger logger = LoggerFactory.getLogger(ItemSequencesStore.class);
	private final BmContext ctx;

	public ItemSequencesStore(BmContext ctx) {
		this.ctx = ctx;
	}

	@Override
	public List<Seq> activeSequences() {
		Seq dir = new Seq("directory", sequence(ctx.getDataSource()));
		DataSource mbox = ctx.getAllMailboxDataSource().getFirst();
		String loc = ctx.dataSourceLocation(mbox);
		Seq mboxSeq = new Seq(loc, sequence(mbox));
		return List.of(dir, mboxSeq);

	}

	private long sequence(DataSource dataSource) {
		try (Connection connection = dataSource.getConnection(); Statement stmt = connection.createStatement()) {
			ResultSet result = stmt.executeQuery("select last_value as seq from t_container_item_id_seq");
			result.next();
			return result.getLong("seq");
		} catch (SQLException e) {
			logger.error("Unable to fetch max id from t_container_item", e);
			return 0;
		}
	}

}
