import { Parameters } from "../parameters.type";

import { textContent, htmlContent, reportContent } from "./partContents";
import { subject } from "./subject";

export default function getMDNStructure(parameters: Parameters) {
    return {
        subject: subject(parameters),
        mime: "multipart/report",
        children: [
            {
                mime: "multipart/alternative",
                children: [
                    {
                        charset: "utf-8",
                        encoding: "quoted-printable",
                        mime: "text/plain",
                        content: textContent(parameters)
                    },
                    {
                        charset: "utf-8",
                        encoding: "quoted-printable",
                        mime: "text/html",
                        content: htmlContent(parameters)
                    }
                ]
            },
            {
                dispositionType: "ATTACHMENT",
                encoding: "7bit",
                fileName: "MDN.txt",
                mime: "message/disposition-notification",
                content: reportContent(parameters)
            }
        ]
    };
}
