import { downloadZip } from "client-zip";

export function createDownloadLink(href: string, name: string) {
    const link = document.createElement("a");
    link.setAttribute("download", name);
    link.setAttribute("href", href);
    link.setAttribute("target", "_blank");
    return link;
}

export async function createZipBlob(files: Array<{ filename: string; url: string }>) {
    const nameCounts = new Map<string, number>();
    const filesWithUniqueNames = files.map(f => ({
        name: getUniqueFilename(f.filename, nameCounts),
        url: f.url
    }));
    const fetchedFiles = await Promise.all(
        filesWithUniqueNames.map(async f => ({
            name: f.name,
            input: await fetch(f.url)
        }))
    );
    return downloadZip(fetchedFiles).blob();
}

function getUniqueFilename(filename: string, nameCounts: Map<string, number>): string {
    if (nameCounts.has(filename)) {
        const count = (nameCounts.get(filename) ?? 0) + 1;
        nameCounts.set(filename, count);
        const lastDotIdx = filename.lastIndexOf(".");
        if (lastDotIdx > 0) {
            const name = filename.substring(0, lastDotIdx);
            const ext = filename.substring(lastDotIdx);
            return `${name}-${count}${ext}`;
        } else {
            return `${filename}-${count}`;
        }
    } else {
        nameCounts.set(filename, 0);
        return filename;
    }
}
