import { SHOW_PREVIEW } from "~/actions";
import { RESET_PREVIEW, SET_PREVIEW_MESSAGE_KEY, SET_PREVIEW_FILE_KEY, SET_PREVIEW_VISIBLE } from "~/mutations";

const state = {
    messageKey: null,
    fileKey: null,
    show: false
};

const mutations = {
    [RESET_PREVIEW](state) {
        state.fileKey = null;
        state.messageKey = null;
    },
    [SET_PREVIEW_FILE_KEY](state, fileKey) {
        state.fileKey = fileKey;
    },
    [SET_PREVIEW_MESSAGE_KEY](state, messageKey) {
        state.messageKey = messageKey;
    },
    [SET_PREVIEW_VISIBLE](state, visible) {
        state.show = visible;
    }
};
const actions = {
    [SHOW_PREVIEW]({ commit, state }, { messageKey, fileKey }) {
        commit(SET_PREVIEW_FILE_KEY, fileKey);
        commit(SET_PREVIEW_MESSAGE_KEY, messageKey);
        state.show = true;
    }
};

export default { state, mutations, actions };
