import { Flag } from "@bluemind/email";

import {
    ADD_ATTACHMENT,
    ADD_FLAG,
    ADD_TAG,
    ADD_LOCAL_ATTACHMENT,
    DEBOUNCED_SAVE_MESSAGE,
    DELETE_FLAG,
    FETCH_MESSAGE_IF_NOT_LOADED,
    FETCH_MESSAGE_METADATA,
    FLUSH_COMPOSER_ACTIONS,
    IMPORT_EML,
    MARK_MESSAGE_AS_FLAGGED,
    MARK_MESSAGE_AS_READ,
    MARK_MESSAGE_AS_UNFLAGGED,
    MARK_MESSAGE_AS_UNREAD,
    MARK_MESSAGES_AS_FLAGGED,
    MARK_MESSAGES_AS_READ,
    MARK_MESSAGES_AS_UNFLAGGED,
    MARK_MESSAGES_AS_UNREAD,
    MOVE_MESSAGES,
    REMOVE_ATTACHMENT,
    REMOVE_MESSAGES,
    REMOVE_TAG,
    REQUEST_DSN,
    TOGGLE_DSN_REQUEST,
    SAVE_AS_DRAFT,
    SAVE_AS_TEMPLATE,
    SAVE_MESSAGE,
    SEND_MDN_TEMPLATE,
    SEND_MESSAGE,
    SCHEDULE_SEND_MESSAGE,
    SET_MESSAGE_CONTENT,
    DEBOUNCED_SET_MESSAGE_CONTENT,
    UPDATE_MESSAGE_STRUCTURE
} from "~/actions";

import { withAlert } from "../../helpers/withAlert";

import {
    addFlag,
    addTag,
    deleteFlag,
    fetchMessageIfNotLoaded,
    fetchMessageMetadata,
    flushScheduledActions,
    moveMessages,
    removeMessages,
    removeTag
} from "./actions";
import { addAttachment, addLocalAttachment, removeAttachment } from "./attachment";
import importEml from "./importEml";
import { debouncedSave, saveAsap } from "./save";
import send from "./send";

import sendMDNTemplate from "./sendMDNTemplate";
import setMessageContent, { debouncedSetMessageContent } from "./setMessageContent";
import updateMessageStructure from "./updateMessageStructure";

const markAsUnread = ({ dispatch }, messages) => dispatch(DELETE_FLAG, { messages, flag: Flag.SEEN });
const markAsRead = ({ dispatch }, messages) => dispatch(ADD_FLAG, { messages, flag: Flag.SEEN });
const markAsFlagged = ({ dispatch }, messages) => dispatch(ADD_FLAG, { messages, flag: Flag.FLAGGED });
const markAsUnflagged = ({ dispatch }, messages) => dispatch(DELETE_FLAG, { messages, flag: Flag.FLAGGED });
const requestDSN = ({ dispatch }, messages) => dispatch(ADD_FLAG, { messages, flag: Flag.BM_DSN });
const toggleDSNRequest = ({ dispatch }, message) =>
    dispatch(message.flags.includes(Flag.BM_DSN) ? DELETE_FLAG : ADD_FLAG, { messages: [message], flag: Flag.BM_DSN });
const saveAs = (context, { message }) => saveAsap(context, { draft: message });
export default {
    [ADD_ATTACHMENT]: addAttachment,
    [ADD_FLAG]: addFlag,
    [ADD_TAG]: addTag,
    [ADD_LOCAL_ATTACHMENT]: addLocalAttachment,
    [DEBOUNCED_SAVE_MESSAGE]: debouncedSave,
    [DELETE_FLAG]: deleteFlag,
    [REMOVE_TAG]: removeTag,
    [FETCH_MESSAGE_IF_NOT_LOADED]: fetchMessageIfNotLoaded,
    [FETCH_MESSAGE_METADATA]: fetchMessageMetadata,
    [FLUSH_COMPOSER_ACTIONS]: flushScheduledActions,
    [IMPORT_EML]: importEml,
    [MARK_MESSAGE_AS_FLAGGED]: markAsFlagged,
    [MARK_MESSAGE_AS_READ]: markAsRead,
    [MARK_MESSAGE_AS_UNFLAGGED]: markAsUnflagged,
    [MARK_MESSAGE_AS_UNREAD]: markAsUnread,
    [MARK_MESSAGES_AS_FLAGGED]: withAlert(markAsFlagged, MARK_MESSAGES_AS_FLAGGED),
    [MARK_MESSAGES_AS_READ]: withAlert(markAsRead, MARK_MESSAGES_AS_READ),
    [MARK_MESSAGES_AS_UNFLAGGED]: withAlert(markAsUnflagged, MARK_MESSAGES_AS_UNFLAGGED),
    [MARK_MESSAGES_AS_UNREAD]: withAlert(markAsUnread, MARK_MESSAGES_AS_UNREAD),
    [MOVE_MESSAGES]: withAlert(moveMessages, MOVE_MESSAGES, "MoveMessages"),
    [REMOVE_ATTACHMENT]: removeAttachment,
    [REMOVE_MESSAGES]: withAlert(removeMessages, REMOVE_MESSAGES, "RemoveMessages"),
    [REQUEST_DSN]: requestDSN,
    [SAVE_AS_DRAFT]: withAlert(saveAs, SAVE_AS_DRAFT, "SaveMessageAs"),
    [SAVE_AS_TEMPLATE]: withAlert(saveAs, SAVE_AS_TEMPLATE, "SaveMessageAs"),
    [SAVE_MESSAGE]: saveAsap,
    [SEND_MESSAGE]: withAlert(send, SEND_MESSAGE, "SendMessage"),
    [SCHEDULE_SEND_MESSAGE]: withAlert(send, SCHEDULE_SEND_MESSAGE, "SendScheduleMessage"),
    [SEND_MDN_TEMPLATE]: sendMDNTemplate,
    [SET_MESSAGE_CONTENT]: setMessageContent,
    [DEBOUNCED_SET_MESSAGE_CONTENT]: debouncedSetMessageContent,
    [TOGGLE_DSN_REQUEST]: toggleDSNRequest,
    [UPDATE_MESSAGE_STRUCTURE]: updateMessageStructure
};
