import { messageUtils } from "@bluemind/mail";

import type { Conversation } from "./conversation.type";

const { createOnlyMetadata } = messageUtils;

export function fakeConversationToMessage(conversation: Conversation) {
    return createOnlyMetadata({
        internalId: parseInt(conversation.remoteRef.uid),
        folder: conversation.folderRef,
        conversationRef: { key: conversation.key, uid: conversation.conversationUid }
    });
}
