import apiConversations from "../api/apiConversations";
import apiMessages from "../api/apiMessages";

import { fakeConversationToMessage } from "./conversationMapper";

type Conversation = {
    conversationUid: string;
    folderRef: string;
    key: string;
    remoteRef: { uid: string };
};
type Flag = string;
type Mailbox = { uid: string };
type Folder = { uid: string };

export default class ApiService {
    private conversationsActivated: boolean;

    constructor(conversationsActivated: boolean) {
        this.conversationsActivated = conversationsActivated;
    }

    async addFlag(conversations: Conversation[], flag: Flag, mailbox?: Mailbox): Promise<void> {
        if (this.conversationsActivated) {
            return apiConversations.addFlag(conversations, flag, mailbox);
        } else {
            const messages = conversations.map(fakeConversationToMessage);
            return apiMessages.addFlag(messages, flag);
        }
    }
    async deleteFlag(conversations: Conversation[], flag: Flag, mailbox?: Mailbox): Promise<void> {
        if (this.conversationsActivated) {
            return apiConversations.deleteFlag(conversations, flag, mailbox);
        } else {
            const messages = conversations.map(fakeConversationToMessage);
            return apiMessages.deleteFlag(messages, flag);
        }
    }
    async multipleDeleteById(conversations: Conversation[], mailbox?: Mailbox): Promise<void> {
        if (this.conversationsActivated) {
            return apiConversations.multipleDeleteById(conversations, mailbox);
        } else {
            const messages = conversations.map(fakeConversationToMessage);
            return apiMessages.multipleDeleteById(messages);
        }
    }
    async multipleUnexpungeById(conversations: Conversation[]): Promise<void> {
        const messages = conversations.map(fakeConversationToMessage);
        return apiMessages.multipleUnexpungeById(messages);
    }
    async move(conversations: Conversation[], folder: Folder, mailbox?: Mailbox): Promise<void> {
        if (this.conversationsActivated) {
            return apiConversations.move(conversations, folder, mailbox);
        } else {
            const messages = conversations.map(fakeConversationToMessage);
            return apiMessages.move(messages, folder);
        }
    }
}
