import { chunk } from "@bluemind/commons.light/utils/array";
import { ContainersClient, ItemFlag } from "@bluemind/core.container.api";
import { SharedContainersClient } from "@bluemind/core.container.api";
import { inject } from "@bluemind/inject";

async function getAllFolders(mailbox) {
    return await apiClient(mailbox.remoteRef).all();
}

async function createNewFolder(mailbox, remoteFolder) {
    return await apiClient(mailbox.remoteRef).createBasic(remoteFolder.value);
}
async function deleteFolder(mailbox, folder) {
    await apiClient(mailbox.remoteRef).deepDelete(folder.remoteRef.internalId);
}
async function updateFolder(mailbox, remoteFolder) {
    await apiClient(mailbox.remoteRef).updateById(remoteFolder.internalId, remoteFolder.value);
}
async function markAsRead(mailbox, folder) {
    return await apiClient(mailbox.remoteRef).markFolderAsRead(folder.remoteRef.internalId);
}
async function emptyFolder(mailbox, folder, deep) {
    if (deep) {
        return await apiClient(mailbox.remoteRef).emptyFolder(folder.remoteRef.internalId);
    } else {
        return await apiClient(mailbox.remoteRef).removeMessages(folder.remoteRef.internalId);
    }
}
async function unreadCount(folder) {
    return apiItems(folder).count({ must: [], mustNot: [ItemFlag.Deleted, ItemFlag.Seen] });
}
async function unreadCounts(mailbox, folders, chunkSize = 500) {
    const allIds = folders.map(folder => folder.remoteRef.internalId);
    const chunks = chunk(allIds, chunkSize);
    const unreadCounts = [];
    chunks.forEach(ids => {
        unreadCounts.push(apiClient(mailbox.remoteRef).counters(ids));
    });
    return (await Promise.all(unreadCounts)).flat();
}
async function accessControlList(ids) {
    const session = inject("UserSession");
    // FIXME Code to use when back api stable
    /*   return new ContainersClient(session.sid)
        .getAccessControlLists(ids.map(id => "mbox_records_" + id))
        .reduce((acl, {container, givenRights}) => {
          const uid = container.uid.replace(/^mbox_records_/, "");
          const verbs = Array.from(new Set(givenRights.flatMap(({verbs}) => verbs)));
          return acl.set(container.uid.replace(/^mbox_records_/, ""), container.verbs)
        }); */

    return (await new ContainersClient(session.sid).getContainers(ids.map(id => "mbox_records_" + id))).reduce(
        (acl, container) => acl.set(container.uid.replace(/^mbox_records_/, ""), container.verbs),
        new Map()
    );
}

function apiClient({ uid }) {
    return inject("MailboxFoldersPersistence", uid);
}
function apiItems({ remoteRef: { uid } }) {
    return inject("MailboxItemsPersistence", uid);
}

async function sharedFoldersUids(mailbox) {
    const sharedFolders = await onlyShareFoldersOfOwner(mailbox.owner);

    const mbox_records_uids = new Set();
    sharedFolders.forEach(folder => {
        mbox_records_uids.add(folder.uid.replace("mbox_records_", ""));
    });

    return mbox_records_uids;
}

async function onlyShareFoldersOfOwner(mboxOwner) {
    const userSession = inject("UserSession");
    const sharedFolders = await sharedFolderClient(userSession).getSharedContainers("mailbox_records");
    return sharedFolders.filter(f => f.shared.owner === mboxOwner).map(f => f.shared);
}

function sharedFolderClient(userSession) {
    return new SharedContainersClient(userSession.sid, userSession.domain, userSession.userId);
}

export default {
    getAllFolders,
    createNewFolder,
    deleteFolder,
    emptyFolder,
    markAsRead,
    updateFolder,
    unreadCount,
    unreadCounts,
    sharedFoldersUids,
    accessControlList
};
