type folderRef = {
    key: string;
};

type remoteRef = {
    uid: string;
    internalId: number;
};

export type messageOrRelated = {
    folderRef: folderRef;
    remoteRef: remoteRef;
};

export default class PathParam {
    static _parse(path: string, defaultFolder: string, mapper: (id: string) => string | number) {
        if (path?.includes(":")) {
            const [folderKey, id, action, relatedFolderKey, relatedId] = path.split(":");
            return { folderKey, internalId: mapper(id), action, relatedFolderKey, relatedId: mapper(relatedId) };
        } else {
            return { folderKey: defaultFolder, internalId: mapper(path) };
        }
    }

    static build(messagepath: string, message: messageOrRelated, action?: string, related?: messageOrRelated) {
        if (message === undefined) {
            return messagepath;
        } else if (message) {
            let builtPath = message.folderRef.key + ":" + message.remoteRef.internalId;
            if (action) {
                builtPath += ":" + action;
            }
            if (related) {
                builtPath += ":" + related.folderRef.key + ":" + related.remoteRef.internalId;
            }
            return builtPath;
        }
    }
}
