import { extensions } from "@bluemind/extensions";
import app from "@bluemind/global.app";
import { mailTipUtils } from "@bluemind/mail";

import ForwardedEventAlert from "./calendar/components/alerts/ForwardedEventAlert.vue";
import ForwardEventAlertTrigger from "./calendar/components/alerts/ForwardEventAlertTrigger";
import NotifyOrganizerAlert from "./calendar/components/alerts/NotifyOrganizerAlert.vue";
import NotifyOrganizerTrigger from "./calendar/components/alerts/NotifyOrganizerTrigger";
import PrivateEventNotSentToDelegatesAlert from "./calendar/components/alerts/PrivateEventNotSentToDelegatesAlert.vue";
import ForwardEventHandler from "./calendar/handlers/ForwardEventHandler";
import UsedQuotaAlert from "./components/MailAlerts//UsedQuotaAlert.vue";
import DecoratedFileItem from "./components/MailAttachment/DecoratedFileItem.vue";
import PreviewBlockedRemoteContent from "./components/MailAttachment/Preview/Fallback/PreviewBlockedRemoteContent.vue";
import PreviewTooLarge from "./components/MailAttachment/Preview/Fallback/PreviewTooLarge.vue";

const { MailTipTypes } = mailTipUtils;

export default function () {
    extensions.register("webapp", "net.bluemind.webapp.mail.js", {
        command: {
            name: "get-mail-tips",
            fn: ({ context }) => {
                context.filter.mailTips.push(MailTipTypes.ALERT);
                context.filter.mailTips.push(MailTipTypes.SIGNATURE);
                context.filter.mailTips.push(MailTipTypes.OUT_OF_OFFICE);
                context.filter.mailTips.push(MailTipTypes.OVER_QUOTA);
                return { context };
            }
        }
    });

    app.component("DecoratedFileItem", DecoratedFileItem);
    extensions.register("webapp.mail", "net.bluemind.webapp.mail.js", {
        component: {
            name: "DecoratedFileItem",
            path: "message.file",
            priority: 0
        }
    });

    app.component("PreviewBlockedRemoteContent", PreviewBlockedRemoteContent);
    extensions.register("webapp.mail", "net.bluemind.webapp.mail.js", {
        component: {
            name: "PreviewBlockedRemoteContent",
            path: "file.preview",
            priority: 1
        }
    });

    app.component("PreviewTooLarge", PreviewTooLarge);
    extensions.register("webapp.mail", "net.bluemind.webapp.mail.js", {
        component: {
            name: "PreviewTooLarge",
            path: "file.preview",
            priority: 2
        }
    });
    app.component("ForwardedEventAlert", ForwardedEventAlert);
    app.component("PrivateEventNotSentToDelegatesAlert", PrivateEventNotSentToDelegatesAlert);
    app.component("UsedQuotaAlert", UsedQuotaAlert);
    app.component("NotifyOrganizerAlert", NotifyOrganizerAlert);
    app.component("NotifyOrganizerTrigger", NotifyOrganizerTrigger);
    extensions.register("webapp.mail", "net.bluemind.webapp.mail.js", {
        component: {
            path: "composer.header",
            name: "NotifyOrganizerTrigger"
        }
    });
    app.component("ForwardEventAlertTrigger", ForwardEventAlertTrigger);
    extensions.register("webapp.mail", "net.bluemind.webapp.mail.js", {
        component: {
            path: "viewer.header",
            name: "ForwardEventAlertTrigger"
        }
    });
    extensions.register("webapp", "net.bluemind.webapp.mail.js", {
        command: {
            name: "forward",
            fn: ForwardEventHandler,
            after: true
        }
    });
}
