import { mapActions, mapGetters, mapState } from "vuex";

import MoveMixin from "../MoveMixin";

vi.mock("vuex");
mapActions.mockReturnValue({});
mapGetters.mockReturnValue({});
mapState.mockReturnValue({});

describe("MoveMixin", () => {
    beforeAll(() => {
        MoveMixin.$_MoveMixin_move = vi.fn();
        MoveMixin.$_MoveMixin_moveConversations = vi.fn();
        MoveMixin.$_MoveMixin_create = vi.fn();
        MoveMixin.$router = { navigate: vi.fn() };
        MoveMixin.$_MoveMixin_folders = {
            key: { key: "key", name: "foldername" },
            key2: { key: "key2", name: "foldername2" }
        };
        MoveMixin.$_MoveMixin_mailbox = {};
        MoveMixin.$store = {
            getters: {
                "mail/NEXT_CONVERSATION": vi.fn(() => ({ key: "nextKey", messages: ["m1", "m2"] })),
                "mail/IS_CURRENT_CONVERSATION": vi.fn().mockReturnValue(false)
            }
        };
        MoveMixin.MOVE_CONVERSATIONS = MoveMixin.methods.MOVE_CONVERSATIONS;
        MoveMixin.navigateTo = vi.fn();
    });
    let conversations;
    let folder;
    beforeEach(() => {
        MoveMixin.$_MoveMixin_move.mockClear();
        MoveMixin.$_MoveMixin_create.mockClear();
        MoveMixin.$router.navigate.mockClear();
        MoveMixin.$store.getters["mail/IS_CURRENT_CONVERSATION"].mockClear();
        conversations = [{ key: "conversation", folderRef: { key: "key" } }];
        folder = MoveMixin.$_MoveMixin_folders["key2"];
    });

    test("MOVE_CONVERSATIONS to call moveConversations action", async () => {
        MoveMixin.$store.getters["mail/CONVERSATIONS_ACTIVATED"] = true;
        await MoveMixin.MOVE_CONVERSATIONS({ conversations, folder: folder });
        expect(MoveMixin.$_MoveMixin_moveConversations).toHaveBeenCalledWith({
            conversations,
            conversationsActivated: true,
            folder,
            mailbox: {}
        });
    });

    test("MOVE_CONVERSATIONS not to call create action if folder exist", async () => {
        await MoveMixin.MOVE_CONVERSATIONS({ conversations, folder: folder });
        expect(MoveMixin.$_MoveMixin_create).not.toHaveBeenCalled();
    });
    test("MOVE_CONVERSATIONS to call create action if folder does not exist", async () => {
        const folder = { name: "toto" };
        await MoveMixin.MOVE_CONVERSATIONS({ conversations, folder: folder });
        expect(MoveMixin.$_MoveMixin_create).toHaveBeenCalledWith({
            mailbox: MoveMixin.$_MoveMixin_mailbox,
            ...folder
        });
    });
    test("MOVE_CONVERSATIONS to call navigate if current conversation is moved", async () => {
        MoveMixin.$store.getters["mail/IS_CURRENT_CONVERSATION"].mockReturnValue(true);
        await MoveMixin.MOVE_CONVERSATIONS({ conversations, folder: {} });
        const next = { key: "nextKey", messages: ["m1", "m2"] };
        expect(MoveMixin.navigateTo).toHaveBeenCalledWith(next, conversations[0].folderRef);
    });
});
