import { mapGetters, mapState } from "vuex";

import { loadingStatusUtils } from "@bluemind/mail";

import {
    CONVERSATION_MESSAGE_BY_KEY,
    CONVERSATION_METADATA,
    CURRENT_CONVERSATION_METADATA,
    MY_SENT,
    SELECTION,
    SELECTION_KEYS
} from "~/getters";

export default {
    computed: {
        ...mapGetters("mail", {
            $_SelectionMixin_CONVERSATION_MESSAGE_BY_KEY: CONVERSATION_MESSAGE_BY_KEY,
            $_SelectionMixin_CURRENT_CONVERSATION_METADATA: CURRENT_CONVERSATION_METADATA,
            $_SelectionMixin_MY_SENT: MY_SENT,
            $_SelectionMixin_SELECTION: SELECTION,
            CONVERSATION_METADATA,
            SELECTION_KEYS
        }),
        ...mapState("mail", {
            $_SelectionMixin_currentConversation: ({ conversations }) => conversations.currentConversation
        }),
        selected() {
            if (this.$_SelectionMixin_SELECTION.length > 0) {
                return this.$_SelectionMixin_SELECTION;
            } else if (this.$_SelectionMixin_currentConversation) {
                return [this.$_SelectionMixin_CURRENT_CONVERSATION_METADATA];
            }
            return [];
        },
        selectionLength() {
            const selectionLength = this.SELECTION_KEYS.length;
            if (selectionLength > 0) {
                return selectionLength;
            }
            return this.$_SelectionMixin_CURRENT_CONVERSATION_METADATA ? 1 : 0;
        },
        isSelectionLoaded() {
            return this.SELECTION_KEYS.every(
                key => this.CONVERSATION_METADATA(key).loading === loadingStatusUtils.LoadingStatus.LOADED
            );
        }
    }
};
