import { mapGetters } from "vuex";

import { CONVERSATIONS_ACTIVATED, CURRENT_CONVERSATION_METADATA } from "~/getters";

import SelectionMixin from "./SelectionMixin";

export default {
    mixins: [SelectionMixin],
    computed: {
        ...mapGetters("mail", { $_AlertTextMixin_CONVERSATIONS_ACTIVATED: CONVERSATIONS_ACTIVATED }),
        $_ActionTextMixin_subject() {
            const currentConversation = this.$store.getters["mail/" + CURRENT_CONVERSATION_METADATA];
            return currentConversation ? currentConversation.subject : "";
        },
        markAsReadText() {
            return this.$t("mail.actions.mark_read", this.selectionLength);
        },
        sendText() {
            return this.$t("mail.actions.send", this.selectionLength);
        },
        sendLaterText() {
            return this.$t("mail.actions.reschedule_later", this.selectionLength);
        },
        markAsUnreadText() {
            return this.$t("mail.actions.mark_unread", this.selectionLength);
        },
        markAsFlaggedText() {
            return this.$t("mail.actions.mark_flagged", this.selectionLength);
        },
        markAsUnflaggedText() {
            return this.$t("mail.actions.mark_unflagged", this.selectionLength);
        },
        removeText() {
            return this.$t("mail.actions.remove", this.selectionLength);
        },
        moveText() {
            return this.$t("mail.actions.move", this.selectionLength);
        },
        unexpungeText() {
            return this.$t("mail.actions.unexpunge", this.selectionLength);
        }
    },
    methods: {
        sendAriaText(length = this.selectionLength, subject = this.$_ActionTextMixin_subject) {
            return this.$_AlertTextMixin_CONVERSATIONS_ACTIVATED
                ? this.$t("mail.actions.send_conversations.aria", { subject }, length)
                : this.$t("mail.actions.send.aria", { subject }, length);
        },
        sendLaterAriaText(length = this.selectionLength, subject = this.$_ActionTextMixin_subject) {
            return this.$t("mail.actions.reschedule_later.aria", { subject }, length);
        },
        markAsReadAriaText(length = this.selectionLength, subject = this.$_ActionTextMixin_subject) {
            return this.$_AlertTextMixin_CONVERSATIONS_ACTIVATED
                ? this.$t("mail.actions.mark_conversations_read.aria", { subject }, length)
                : this.$t("mail.actions.mark_read.aria", { subject }, length);
        },
        markAsUnreadAriaText(length = this.selectionLength, subject = this.$_ActionTextMixin_subject) {
            return this.$_AlertTextMixin_CONVERSATIONS_ACTIVATED
                ? this.$t("mail.actions.mark_conversations_unread.aria", { subject }, length)
                : this.$t("mail.actions.mark_unread.aria", { subject }, length);
        },
        markAsFlaggedAriaText(length = this.selectionLength, subject = this.$_ActionTextMixin_subject) {
            return this.$_AlertTextMixin_CONVERSATIONS_ACTIVATED
                ? this.$t("mail.actions.mark_conversations_flagged.aria", { subject }, length)
                : this.$t("mail.actions.mark_flagged.aria", { subject }, length);
        },
        markAsUnflaggedAriaText(length = this.selectionLength, subject = this.$_ActionTextMixin_subject) {
            return this.$_AlertTextMixin_CONVERSATIONS_ACTIVATED
                ? this.$t("mail.actions.mark_conversations_unflagged.aria", { subject }, length)
                : this.$t("mail.actions.mark_unflagged.aria", { subject }, length);
        },
        removeAriaText(length = this.selectionLength, subject = this.$_ActionTextMixin_subject) {
            return this.$_AlertTextMixin_CONVERSATIONS_ACTIVATED
                ? this.$t("mail.actions.remove.conversations.aria", { subject }, length)
                : this.$t("mail.actions.remove.aria", { subject }, length);
        },
        moveAriaText(length = this.selectionLength, subject = this.$_ActionTextMixin_subject) {
            return this.$_AlertTextMixin_CONVERSATIONS_ACTIVATED
                ? this.$t("mail.actions.move.conversations.aria", { subject }, length)
                : this.$t("mail.actions.move.aria", { subject }, length);
        },
        unexpungeAriaText(length = this.selectionLength, subject = this.$_ActionTextMixin_subject) {
            return this.$t("mail.actions.unexpunge.aria", { subject, count: length }, length);
        }
    }
};
