import { computed } from "vue";

import store from "@bluemind/store";

import { ADD_TAG_TO_CONVERSATIONS, REMOVE_TAG_FROM_CONVERSATIONS } from "~/actions";
import { CONVERSATIONS_ACTIVATED, CURRENT_MAILBOX, SELECTION, CURRENT_CONVERSATION_METADATA } from "~/getters";

type conversationKeys = { key: number; foldeRef: { key: string } };
export function useTags() {
    const currentConversation = computed(() => store.state.mail.conversations.currentConversation);
    const selected = computed<Array<conversationKeys>>(() => {
        const selection = store.getters[`mail/${SELECTION}`];
        if (selection.length > 0) {
            return selection;
        } else if (currentConversation.value) {
            return [store.getters[`mail/${CURRENT_CONVERSATION_METADATA}`]];
        }
        return [];
    });
    const addTag = (tag: string, conversations?: Array<conversationKeys>): void => {
        store.dispatch(`mail/${ADD_TAG_TO_CONVERSATIONS}`, {
            tag,
            conversations: conversations || selected.value,
            conversationsActivated: store.getters[`mail/${CONVERSATIONS_ACTIVATED}`],
            mailbox: store.getters[`mail/${CURRENT_MAILBOX}`]
        });
    };

    const removeTag = (tag: string, conversations?: Array<conversationKeys>): void => {
        store.dispatch(`mail/${REMOVE_TAG_FROM_CONVERSATIONS}`, {
            tag,
            conversations: conversations || selected.value,
            conversationsActivated: store.getters[`mail/${CONVERSATIONS_ACTIVATED}`],
            mailbox: store.getters[`mail/${CURRENT_MAILBOX}`]
        });
    };

    return {
        addTag,
        removeTag
    };
}
