import { Contact } from "@bluemind/business-components/packages/contact/contact.type";
import { Fields, searchVCardsHelper } from "@bluemind/contact";
import { EmailExtractor } from "@bluemind/email";
import i18n from "@bluemind/i18n";
import { inject } from "@bluemind/inject";

export function usePhishingUtils() {
    async function getAddressBooksByDisplayName(contact: Contact) {
        const recipient = contact.dn ? contact.dn + (contact.address ? ` <${contact.address}>` : "") : contact.address;
        const searchToken = EmailExtractor.extractDN(recipient);
        const searchResults = await inject("AddressBooksPersistence").search(
            searchVCardsHelper(searchToken, {
                size: 1,
                fields: [Fields.NAME, Fields.EMAIL]
            })
        );
        return searchResults;
    }
    async function checkPhishing(contact: Contact) {
        if (!contact.dn) {
            return false;
        }
        const search = await getAddressBooksByDisplayName(contact);
        return search.values[0]?.value.formatedName === contact.dn || search.values[0]?.value.mail === contact.dn;
    }
    function getIcon(isPhishingSuspect: boolean) {
        if (isPhishingSuspect) {
            return {
                className: "icon-danger",
                icon: "user-exclamation",
                title: i18n.global.t("styleguide.contact-input.phishing")
            };
        }
        return {
            className: "icon-warning",
            icon: "user-interrogation",
            title: i18n.global.t("styleguide.contact-input.unknown")
        };
    }
    return { checkPhishing, getIcon };
}
