import { computed } from "vue";

import vuexStore from "@bluemind/store";

import { CURRENT_MAILBOX } from "../store/types/getters";

export default function useTagContainerUid() {
    const containerUid = computed(() => {
        const ownerUid = vuexStore.getters[`mail/${CURRENT_MAILBOX}`].owner;
        return `tags_${ownerUid}`;
    });
    return { containerUid };
}
