function needsEscape(value: string) {
    const anySpecialCharacter = /[^\p{L}\w]/u;
    return anySpecialCharacter.test(value);
}

export function escapeTerm(value: string) {
    return needsEscape(value) ? `"${value.replace(/["\\()]/g, "\\$&")}"` : value;
}

export function unescapeTerm(value: string) {
    return value.replace(/\\(["\\()])/g, "$1");
}
